/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.controll;

import com.badlogic.gdx.Gdx;
import de.hsw.mertcraft.controll.GameCamera;
import de.hsw.mertcraft.game.GameSession;
import de.hsw.mertcraft.shared.block.Block;
import de.hsw.mertcraft.shared.block.BlockRegistry;
import de.hsw.mertcraft.shared.block.BlockType;
import de.hsw.mertcraft.shared.net.packet.ChangeBlockPacket;
import de.hsw.mertcraft.shared.net.packet.Services;
import de.hsw.mertcraft.shared.net.packet.client.ClientInteractPacket;
import de.hsw.mertcraft.shared.world.ChunkPos;
import de.hsw.mertcraft.shared.world.World;
import lombok.Generated;

public final class WorldEditorController {
    private final World world;
    private final GameCamera cam;
    private final float reach = 5.0f;
    private BlockType selectedType = BlockRegistry.byId((short)0);

    public WorldEditorController(World world, GameCamera cam) {
        this.world = world;
        this.cam = cam;
    }

    public void update() {
        if (!Gdx.input.isButtonJustPressed(0) && !Gdx.input.isButtonJustPressed(1)) {
            for (int i = 1; i <= BlockRegistry.maxId(); ++i) {
                if (!Gdx.input.isKeyJustPressed(i + 7)) continue;
                this.selectedType = BlockRegistry.byId((short)i);
            }
            return;
        }
        GameSession.getInstance().execute(Services.PlayerInteractService.class, new ClientInteractPacket(GameSession.getInstance().getSelf().getId()));
        GameCamera.Hit h = this.cam.raycastBlock(5.0f);
        if (h == null) {
            return;
        }
        if (Gdx.input.isButtonJustPressed(0)) {
            short block = this.world.getBlock(h.bx, h.by, h.bz);
            int cx = ChunkPos.toChunkX(h.bx);
            int cz = ChunkPos.toChunkZ(h.bz);
            if (BlockRegistry.unpack(block) != BlockRegistry.AIR && this.world.getChunk(cx, cz) != null && h.by >= 0 && h.by < 128) {
                GameSession.getInstance().execute(Services.PlayerChangeBlockService.class, new ChangeBlockPacket(h.bx, h.by, h.bz, Block.AIR_PACKED));
            }
        }
        if (Gdx.input.isButtonJustPressed(1)) {
            int px = h.px;
            int py = h.py;
            int pz = h.pz;
            short block = this.world.getBlock(px, py, pz);
            int cx = ChunkPos.toChunkX(px);
            int cz = ChunkPos.toChunkZ(pz);
            if (block == Block.AIR_PACKED && this.world.getChunk(cx, cz) != null && py >= 0 && py < 128) {
                GameSession.getInstance().execute(Services.PlayerChangeBlockService.class, new ChangeBlockPacket(px, py, pz, Block.pack(this.selectedType.id, (byte)0)));
            }
        }
    }

    @Generated
    public BlockType getSelectedType() {
        return this.selectedType;
    }
}

