/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.entity;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import java.util.function.Function;
import lombok.Generated;

public class VoxelPlayer {
    private final Model model;
    private final ModelInstance instance;
    private final Texture skin;
    private final Node nRoot;
    private final Node nBody;
    private final Node nHead;
    private final Node nArmR;
    private final Node nArmL;
    private final Node nLegR;
    private final Node nLegL;
    private float walkT = 0.0f;
    private float bodyYawDeg = 0.0f;
    private final Vector3 p1 = new Vector3();
    private final Vector3 p2 = new Vector3();
    private final Vector3 p3 = new Vector3();
    private final Vector3 p4 = new Vector3();
    private final Vector3 tmpN = new Vector3();
    private final VoxelArmSwing armSwing;

    public VoxelPlayer(String skinPath) {
        this.skin = new Texture(Gdx.files.internal(skinPath));
        this.skin.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        this.skin.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        this.model = this.buildRiggedModel();
        this.instance = new ModelInstance(this.model);
        this.nRoot = this.instance.getNode("Root", true);
        this.nBody = this.instance.getNode("Body", true);
        this.nHead = this.instance.getNode("Head", true);
        this.nArmR = this.instance.getNode("ArmR", true);
        this.nArmL = this.instance.getNode("ArmL", true);
        this.nLegR = this.instance.getNode("LegR", true);
        this.nLegL = this.instance.getNode("LegL", true);
        this.armSwing = new VoxelArmSwing(this.nArmL);
    }

    public ModelInstance getRightArmCopy() {
        ModelInstance instance = new ModelInstance(this.model);
        for (Node n : instance.nodes) {
            for (NodePart part : n.parts) {
                part.enabled = false;
            }
        }
        Node n = instance.getNode("RightArm", true);
        this.enableSubtree(n);
        return instance;
    }

    private void enableSubtree(Node n) {
        for (NodePart np : n.parts) {
            np.enabled = true;
        }
        for (Node c : n.getChildren()) {
            this.enableSubtree(c);
        }
    }

    public void update(Vector3 pos, Vector3 vel, float camYaw, float camPitch, float dt) {
        this.instance.transform.setToTranslation(pos);
        float speed = (float)Math.sqrt(vel.x * vel.x + vel.z * vel.z);
        float freq = 2.5f;
        if (speed > 0.02f) {
            this.walkT += freq * dt;
        }
        float legAmp = speed > 0.02f ? 0.6f : 0.0f;
        float armAmp = speed > 0.02f ? 0.45f : 0.0f;
        float legR = MathUtils.sin(this.walkT) * legAmp;
        float legL = MathUtils.sin(this.walkT + (float)Math.PI) * legAmp;
        float armR = MathUtils.sin(this.walkT + (float)Math.PI) * armAmp;
        float armL = MathUtils.sin(this.walkT) * armAmp;
        if (speed > 0.05f) {
            float targetBodyYaw = MathUtils.atan2(vel.x, vel.z) * 57.295776f;
            this.bodyYawDeg = MathUtils.lerpAngleDeg(this.bodyYawDeg, targetBodyYaw, 0.18f);
        }
        this.setRotY(this.nRoot, this.bodyYawDeg);
        this.setRotX(this.nLegR, legR * 57.295776f);
        this.setRotX(this.nLegL, legL * 57.295776f);
        this.setRotX(this.nArmR, armR * 57.295776f);
        this.setRotX(this.nArmL, armL * 57.295776f);
        float targetHeadYawLocal = VoxelPlayer.wrapDeg(camYaw - this.bodyYawDeg) + 180.0f;
        float targetHeadPitchLocal = VoxelPlayer.clamp(-camPitch, -35.0f, 50.0f);
        this.setRotYX(this.nHead, targetHeadYawLocal, targetHeadPitchLocal);
        this.armSwing.update(dt);
        this.instance.calculateTransforms();
    }

    public void render(ModelBatch batch, Environment env) {
        batch.render((RenderableProvider)this.instance, env);
    }

    public void dispose() {
        if (this.model != null) {
            this.model.dispose();
        }
        if (this.skin != null) {
            this.skin.dispose();
        }
    }

    static float clamp(float v, float lo, float hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private void setRotYX(Node n, float yawDeg, float pitchDeg) {
        n.rotation.idt().setFromAxis(Vector3.Y, yawDeg).mulLeft(new Quaternion().setFromAxis(Vector3.X, pitchDeg));
    }

    private static UV uv(int x, int y, int w, int h) {
        float pad = 0.5f;
        float u0 = ((float)x + pad) / 64.0f;
        float u1 = ((float)(x + w) - pad) / 64.0f;
        float v0 = ((float)y + pad) / 64.0f;
        float v1 = ((float)(y + h) - pad) / 64.0f;
        return new UV(u0, v0, u1, v1);
    }

    private void rectUV(MeshBuilder mb, Vector3 a, Vector3 b, Vector3 c, Vector3 d, Vector3 n, UV r) {
        float u0 = r.u0;
        float u1 = r.u1;
        float v0 = r.v1;
        float v1 = r.v0;
        mb.setUVRange(u0, v0, u1, v1);
        mb.rect(a, b, c, d, n);
    }

    private void addBoxLocal(MeshBuilder mb, float x0, float y0, float z0, float x1, float y1, float z1, UV top, UV bottom, UV north, UV south, UV west, UV east) {
        this.tmpN.set(1.0f, 0.0f, 0.0f);
        this.p1.set(x1, y1, z0);
        this.p2.set(x1, y1, z1);
        this.p3.set(x1, y0, z1);
        this.p4.set(x1, y0, z0);
        this.rectUV(mb, this.p1, this.p2, this.p3, this.p4, this.tmpN, east);
        this.tmpN.set(-1.0f, 0.0f, 0.0f);
        this.p1.set(x0, y1, z1);
        this.p2.set(x0, y1, z0);
        this.p3.set(x0, y0, z0);
        this.p4.set(x0, y0, z1);
        this.rectUV(mb, this.p1, this.p2, this.p3, this.p4, this.tmpN, west);
        this.tmpN.set(0.0f, 1.0f, 0.0f);
        this.p1.set(x0, y1, z1);
        this.p2.set(x1, y1, z1);
        this.p3.set(x1, y1, z0);
        this.p4.set(x0, y1, z0);
        this.rectUV(mb, this.p1, this.p2, this.p3, this.p4, this.tmpN, top);
        this.tmpN.set(0.0f, -1.0f, 0.0f);
        this.p1.set(x0, y0, z0);
        this.p2.set(x1, y0, z0);
        this.p3.set(x1, y0, z1);
        this.p4.set(x0, y0, z1);
        this.rectUV(mb, this.p1, this.p2, this.p3, this.p4, this.tmpN, bottom);
        this.tmpN.set(0.0f, 0.0f, 1.0f);
        this.p1.set(x1, y1, z1);
        this.p2.set(x0, y1, z1);
        this.p3.set(x0, y0, z1);
        this.p4.set(x1, y0, z1);
        this.rectUV(mb, this.p1, this.p2, this.p3, this.p4, this.tmpN, south);
        this.tmpN.set(0.0f, 0.0f, -1.0f);
        this.p1.set(x0, y1, z0);
        this.p2.set(x1, y1, z0);
        this.p3.set(x1, y0, z0);
        this.p4.set(x0, y0, z0);
        this.rectUV(mb, this.p1, this.p2, this.p3, this.p4, this.tmpN, north);
    }

    private MeshBuilder beginMesh() {
        MeshBuilder mb = new MeshBuilder();
        mb.begin(25L, 4);
        return mb;
    }

    private Model buildRiggedModel() {
        float S = 0.0625f;
        Material mat = new Material(TextureAttribute.createDiffuse(this.skin), IntAttribute.createCullFace(0));
        Model model = new Model();
        model.materials.add(mat);
        Node root = new Node();
        root.id = "Root";
        model.nodes.add(root);
        Function<Mesh, MeshPart> mkPart = mesh -> {
            MeshPart mp = new MeshPart();
            mp.id = "part";
            mp.mesh = mesh;
            mp.offset = 0;
            mp.size = mesh.getNumIndices();
            mp.primitiveType = 4;
            return mp;
        };
        MeshBuilder mb = this.beginMesh();
        UV top = VoxelPlayer.uv(20, 16, 8, 4);
        UV bottom = VoxelPlayer.uv(28, 16, 8, 4);
        UV north = VoxelPlayer.uv(32, 20, 8, 12);
        UV south = VoxelPlayer.uv(20, 20, 8, 12);
        UV west = VoxelPlayer.uv(28, 20, 4, 12);
        UV east = VoxelPlayer.uv(16, 20, 4, 12);
        this.addBoxLocal(mb, -0.25f, 0.0f, -0.125f, 0.25f, 0.75f, 0.125f, top, bottom, north, south, west, east);
        Mesh mesh2 = mb.end();
        model.meshes.add(mesh2);
        Node body = new Node();
        body.id = "Body";
        body.translation.set(0.0f, 0.75f, 0.0f);
        NodePart np = new NodePart();
        np.meshPart = mkPart.apply(mesh2);
        np.material = mat;
        body.parts.add(np);
        root.addChild(body);
        mb = this.beginMesh();
        top = VoxelPlayer.uv(8, 0, 8, 8);
        bottom = VoxelPlayer.uv(16, 0, 8, 8);
        north = VoxelPlayer.uv(24, 8, 8, 8);
        south = VoxelPlayer.uv(8, 8, 8, 8);
        west = VoxelPlayer.uv(16, 8, 8, 8);
        east = VoxelPlayer.uv(0, 8, 8, 8);
        this.addBoxLocal(mb, -0.25f, 0.0f, -0.25f, 0.25f, 0.5f, 0.25f, top, bottom, north, south, west, east);
        mesh2 = mb.end();
        model.meshes.add(mesh2);
        Node head = new Node();
        head.id = "Head";
        head.translation.set(0.0f, 1.5f, 0.0f);
        np = new NodePart();
        np.meshPart = mkPart.apply(mesh2);
        np.material = mat;
        head.parts.add(np);
        root.addChild(head);
        mb = this.beginMesh();
        top = VoxelPlayer.uv(44, 16, 4, 4);
        bottom = VoxelPlayer.uv(48, 16, 4, 4);
        north = VoxelPlayer.uv(52, 20, 4, 12);
        south = VoxelPlayer.uv(44, 20, 4, 12);
        west = VoxelPlayer.uv(48, 20, 4, 12);
        east = VoxelPlayer.uv(40, 20, 4, 12);
        this.addBoxLocal(mb, -0.125f, -0.75f, -0.125f, 0.125f, 0.0f, 0.125f, top, bottom, north, south, west, east);
        mesh2 = mb.end();
        model.meshes.add(mesh2);
        Node arm = new Node();
        arm.id = "ArmR";
        arm.translation.set(0.375f, 1.5f, 0.0f);
        np = new NodePart();
        np.meshPart = mkPart.apply(mesh2);
        np.material = mat;
        arm.parts.add(np);
        root.addChild(arm);
        mb = this.beginMesh();
        top = VoxelPlayer.uv(44, 16, 4, 4);
        bottom = VoxelPlayer.uv(48, 16, 4, 4);
        north = VoxelPlayer.uv(52, 20, 4, 12);
        south = VoxelPlayer.uv(44, 20, 4, 12);
        west = VoxelPlayer.uv(48, 20, 4, 12);
        east = VoxelPlayer.uv(40, 20, 4, 12);
        this.addBoxLocal(mb, -0.125f, -0.75f, -0.125f, 0.125f, 0.0f, 0.125f, top, bottom, north, south, west, east);
        mesh2 = mb.end();
        model.meshes.add(mesh2);
        arm = new Node();
        arm.id = "ArmL";
        arm.translation.set(-0.375f, 1.5f, 0.0f);
        np = new NodePart();
        np.meshPart = mkPart.apply(mesh2);
        np.material = mat;
        arm.parts.add(np);
        root.addChild(arm);
        mb = this.beginMesh();
        top = VoxelPlayer.uv(4, 16, 4, 4);
        bottom = VoxelPlayer.uv(8, 16, 4, 4);
        north = VoxelPlayer.uv(12, 20, 4, 12);
        south = VoxelPlayer.uv(4, 20, 4, 12);
        west = VoxelPlayer.uv(8, 20, 4, 12);
        east = VoxelPlayer.uv(0, 20, 4, 12);
        this.addBoxLocal(mb, -0.125f, -0.75f, -0.125f, 0.125f, 0.0f, 0.125f, top, bottom, north, south, west, east);
        mesh2 = mb.end();
        model.meshes.add(mesh2);
        Node leg = new Node();
        leg.id = "LegR";
        leg.translation.set(-0.125f, 0.75f, 0.0f);
        np = new NodePart();
        np.meshPart = mkPart.apply(mesh2);
        np.material = mat;
        leg.parts.add(np);
        root.addChild(leg);
        mb = this.beginMesh();
        top = VoxelPlayer.uv(4, 16, 4, 4);
        bottom = VoxelPlayer.uv(8, 16, 4, 4);
        north = VoxelPlayer.uv(12, 20, 4, 12);
        south = VoxelPlayer.uv(4, 20, 4, 12);
        west = VoxelPlayer.uv(8, 20, 4, 12);
        east = VoxelPlayer.uv(0, 20, 4, 12);
        this.addBoxLocal(mb, -0.125f, -0.75f, -0.125f, 0.125f, 0.0f, 0.125f, top, bottom, north, south, west, east);
        mesh2 = mb.end();
        model.meshes.add(mesh2);
        leg = new Node();
        leg.id = "LegL";
        leg.translation.set(0.125f, 0.75f, 0.0f);
        np = new NodePart();
        np.meshPart = mkPart.apply(mesh2);
        np.material = mat;
        leg.parts.add(np);
        root.addChild(leg);
        for (Mesh m : model.meshes) {
            model.manageDisposable(m);
        }
        return model;
    }

    private void setRotX(Node n, float deg) {
        n.rotation.setFromAxis(Vector3.X, deg);
    }

    private void setRotY(Node n, float deg) {
        n.rotation.setFromAxis(Vector3.Y, deg);
    }

    static float wrapDeg(float a) {
        if ((a = (a + 180.0f) % 360.0f) < 0.0f) {
            a += 360.0f;
        }
        return a - 180.0f;
    }

    static float deltaAngleDeg(float from, float to) {
        return VoxelPlayer.wrapDeg(to - from);
    }

    static float lerpAngleDeg(float from, float to, float alpha) {
        return from + VoxelPlayer.deltaAngleDeg(from, to) * alpha;
    }

    @Generated
    public VoxelArmSwing getArmSwing() {
        return this.armSwing;
    }

    public static class VoxelArmSwing {
        private final Node armR;
        private final Quaternion bindRot = new Quaternion();
        private final Quaternion tmp = new Quaternion();
        private float t = 0.0f;
        private boolean playing = false;
        private float duration = 0.35f;
        private float impactAt = 0.45f;
        private boolean impactFired = false;
        private Runnable onImpact = null;
        private float swingPitch = -60.0f;
        private float swingYaw = 15.0f;
        private float swingRoll = 10.0f;
        private float bindYawOffsetDeg = 0.0f;
        private float bindPitchOffsetDeg = 0.0f;
        private float bindRollOffsetDeg = 0.0f;

        public VoxelArmSwing(Node rightArmNode) {
            this.armR = rightArmNode;
            this.bindRot.set(this.armR.rotation);
        }

        public void start(Runnable onImpact) {
            if (this.playing) {
                return;
            }
            this.onImpact = onImpact;
            this.t = 0.0f;
            this.impactFired = false;
            this.playing = true;
        }

        public void update(float dt) {
            if (!this.playing) {
                return;
            }
            this.t += dt / this.duration;
            float u = Math.min(this.t, 1.0f);
            float f = u <= 0.5f ? VoxelArmSwing.easeOutSine(u * 2.0f) : 1.0f - VoxelArmSwing.easeInSine((u - 0.5f) * 2.0f);
            if (!this.impactFired && u >= this.impactAt) {
                this.impactFired = true;
                if (this.onImpact != null) {
                    this.onImpact.run();
                }
            }
            Quaternion q = this.buildOffset(this.bindYawOffsetDeg + this.swingYaw * f, this.bindPitchOffsetDeg + this.swingPitch * f, this.bindRollOffsetDeg + this.swingRoll * f);
            this.armR.rotation.set(this.bindRot).mulLeft(q);
            if (u >= 1.0f) {
                this.armR.rotation.set(this.bindRot);
                this.playing = false;
            }
        }

        public void setDuration(float seconds) {
            this.duration = Math.max(0.1f, seconds);
        }

        public void setImpactAt(float at01) {
            this.impactAt = MathUtils.clamp(at01, 0.0f, 1.0f);
        }

        public void setSwingAngles(float pitchX, float yawY, float rollZ) {
            this.swingPitch = pitchX;
            this.swingYaw = yawY;
            this.swingRoll = rollZ;
        }

        public void setBindOffsets(float yaw, float pitch, float roll) {
            this.bindYawOffsetDeg = yaw;
            this.bindPitchOffsetDeg = pitch;
            this.bindRollOffsetDeg = roll;
        }

        private static float easeOutSine(float x) {
            return (float)Math.sin((double)(x * (float)Math.PI) * 0.5);
        }

        private static float easeInSine(float x) {
            return 1.0f - (float)Math.cos((double)(x * (float)Math.PI) * 0.5);
        }

        private Quaternion buildOffset(float yawDeg, float pitchDeg, float rollDeg) {
            this.tmp.idt().setFromAxis(Vector3.Y, yawDeg).mulLeft(new Quaternion().setFromAxis(Vector3.X, pitchDeg)).mulLeft(new Quaternion().setFromAxis(Vector3.Z, rollDeg));
            return this.tmp;
        }

        @Generated
        public boolean isPlaying() {
            return this.playing;
        }
    }

    private static class UV {
        float u0;
        float v0;
        float u1;
        float v1;

        UV(float a, float b, float c, float d) {
            this.u0 = a;
            this.v0 = b;
            this.u1 = c;
            this.v1 = d;
        }
    }
}

