/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.ObjectMap;
import de.hsw.mertcraft.io.BlockRenderPalette;
import de.hsw.mertcraft.io.BlockTexturePalette;
import de.hsw.mertcraft.shared.block.Block;
import de.hsw.mertcraft.shared.block.BlockRegistry;
import de.hsw.mertcraft.shared.block.BlockType;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.ChunkPos;
import de.hsw.mertcraft.shared.world.ChunkSection;
import de.hsw.mertcraft.shared.world.World;

public class ChunkMesherColorAO {
    private static final boolean FLIP_SIDE_U = false;
    private static final boolean FLIP_SIDE_V = true;
    private static final boolean ROTATE_SIDE_180 = false;
    private final BlockRenderPalette colorPalette;
    private final BlockTexturePalette texImages;
    private final Vector3 p0 = new Vector3();
    private final Vector3 p1 = new Vector3();
    private final Vector3 p2 = new Vector3();
    private final Vector3 p3 = new Vector3();
    private final Vector3 n = new Vector3();
    private static final float[] AO_LUT = new float[]{1.0f, 0.86f, 0.73f, 0.6f};
    private final Color tmpColor = new Color();

    public ChunkMesherColorAO(BlockRenderPalette colorPalette, BlockTexturePalette images) {
        this.colorPalette = colorPalette;
        this.texImages = images;
    }

    public Model buildSectionModel(World snap, Chunk col, int sy) {
        ChunkSection sec = col.getSection(sy);
        if (sec == null) {
            return null;
        }
        ObjectMap<Texture, MeshBuilder> byTex = new ObjectMap<Texture, MeshBuilder>();
        int attrs = 27;
        int wx0 = col.cx * 16;
        int wz0 = col.cz * 16;
        int y0 = 0 + sy * 16;
        for (int ly = 0; ly < 16; ++ly) {
            int wy = y0 + ly;
            for (int lz = 0; lz < 16; ++lz) {
                int n = wz0 + lz;
                for (int lx = 0; lx < 16; ++lx) {
                    MeshBuilder mb;
                    Texture tex;
                    int wx = wx0 + lx;
                    short packed = sec.get(lx, ly, lz);
                    if (Block.isAir(packed)) continue;
                    BlockType t = BlockRegistry.byId(Block.type(packed));
                    if (!t.opaque) continue;
                    if (!ChunkMesherColorAO.isOpaque(snap, wx + 1, wy, n)) {
                        tex = this.textureFor(t, BlockTexturePalette.Face.PX);
                        mb = this.ensureBuilder(byTex, tex, 27);
                        this.addFace(mb, snap, t, wx, wy, n, 1, 0, 0);
                    }
                    if (!ChunkMesherColorAO.isOpaque(snap, wx - 1, wy, n)) {
                        tex = this.textureFor(t, BlockTexturePalette.Face.NX);
                        mb = this.ensureBuilder(byTex, tex, 27);
                        this.addFace(mb, snap, t, wx, wy, n, -1, 0, 0);
                    }
                    if (!ChunkMesherColorAO.isOpaque(snap, wx, wy + 1, n)) {
                        tex = this.textureFor(t, BlockTexturePalette.Face.PY);
                        mb = this.ensureBuilder(byTex, tex, 27);
                        this.addFace(mb, snap, t, wx, wy, n, 0, 1, 0);
                    }
                    if (!ChunkMesherColorAO.isOpaque(snap, wx, wy - 1, n)) {
                        tex = this.textureFor(t, BlockTexturePalette.Face.NY);
                        mb = this.ensureBuilder(byTex, tex, 27);
                        this.addFace(mb, snap, t, wx, wy, n, 0, -1, 0);
                    }
                    if (!ChunkMesherColorAO.isOpaque(snap, wx, wy, n + 1)) {
                        tex = this.textureFor(t, BlockTexturePalette.Face.PZ);
                        mb = this.ensureBuilder(byTex, tex, 27);
                        this.addFace(mb, snap, t, wx, wy, n, 0, 0, 1);
                    }
                    if (ChunkMesherColorAO.isOpaque(snap, wx, wy, n - 1)) continue;
                    tex = this.textureFor(t, BlockTexturePalette.Face.NZ);
                    mb = this.ensureBuilder(byTex, tex, 27);
                    this.addFace(mb, snap, t, wx, wy, n, 0, 0, -1);
                }
            }
        }
        Model model = new Model();
        Node node = new Node();
        node.id = "sectionNode";
        for (ObjectMap.Entry entry : byTex.entries()) {
            Texture tex = (Texture)entry.key;
            MeshBuilder mb = (MeshBuilder)entry.value;
            Mesh mesh = mb.end();
            Material mat = new Material(TextureAttribute.createDiffuse(tex), ColorAttribute.createDiffuse(Color.WHITE), IntAttribute.createCullFace(1029));
            MeshPart mp = new MeshPart();
            mp.id = "part_" + Integer.toHexString(System.identityHashCode(tex));
            mp.mesh = mesh;
            mp.offset = 0;
            mp.size = mesh.getNumIndices();
            mp.primitiveType = 4;
            NodePart np = new NodePart();
            np.meshPart = mp;
            np.material = mat;
            node.parts.add(np);
            model.meshes.add(mesh);
            model.materials.add(mat);
            model.manageDisposable(mesh);
        }
        model.nodes.add(node);
        return model;
    }

    private MeshBuilder ensureBuilder(ObjectMap<Texture, MeshBuilder> byTex, Texture tex, int attrs) {
        if (tex == null) {
            return null;
        }
        MeshBuilder mb = byTex.get(tex);
        if (mb == null) {
            mb = new MeshBuilder();
            mb.begin(attrs, 4);
            byTex.put(tex, mb);
        }
        return mb;
    }

    private Texture textureFor(BlockType t, BlockTexturePalette.Face face) {
        return this.texImages.texture(t.name, face);
    }

    private void addFace(MeshPartBuilder mb, World snap, BlockType t, int x, int y, int z, int nx, int ny, int nz) {
        MeshPartBuilder.VertexInfo v3i;
        MeshPartBuilder.VertexInfo v2i;
        MeshPartBuilder.VertexInfo v1i;
        MeshPartBuilder.VertexInfo v0i;
        if (mb == null) {
            return;
        }
        this.n.set(nx, ny, nz);
        float x0 = x;
        float y0 = y;
        float z0 = z;
        float x1 = x + 1;
        float y1 = y + 1;
        float z1 = z + 1;
        float ao11 = this.aoLutSample(snap, x, y, z, nx, ny, nz, -1, 1);
        float ao1m = this.aoLutSample(snap, x, y, z, nx, ny, nz, -1, -1);
        float ao11p = this.aoLutSample(snap, x, y, z, nx, ny, nz, 1, 1);
        float ao1mp = this.aoLutSample(snap, x, y, z, nx, ny, nz, 1, -1);
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        if (ny == 0) {
            float tmp = v0;
            v0 = v1;
            v1 = tmp;
        }
        if (nx == 1) {
            this.p0.set(x1, y1, z0);
            this.p1.set(x1, y1, z1);
            this.p2.set(x1, y0, z1);
            this.p3.set(x1, y0, z0);
            v0i = this.V(this.p0, ao11, u0, v1);
            v1i = this.V(this.p1, ao11p, u1, v1);
            v2i = this.V(this.p2, ao1mp, u1, v0);
            v3i = this.V(this.p3, ao1m, u0, v0);
        } else if (nx == -1) {
            this.p0.set(x0, y1, z1);
            this.p1.set(x0, y1, z0);
            this.p2.set(x0, y0, z0);
            this.p3.set(x0, y0, z1);
            v0i = this.V(this.p0, ao11, u0, v1);
            v1i = this.V(this.p1, ao11p, u1, v1);
            v2i = this.V(this.p2, ao1mp, u1, v0);
            v3i = this.V(this.p3, ao1m, u0, v0);
        } else if (ny == 1) {
            this.p0.set(x0, y1, z1);
            this.p1.set(x1, y1, z1);
            this.p2.set(x1, y1, z0);
            this.p3.set(x0, y1, z0);
            v0i = this.V(this.p0, ao11, 0.0f, 1.0f);
            v1i = this.V(this.p1, ao11p, 1.0f, 1.0f);
            v2i = this.V(this.p2, ao1mp, 1.0f, 0.0f);
            v3i = this.V(this.p3, ao1m, 0.0f, 0.0f);
        } else if (ny == -1) {
            this.p0.set(x0, y0, z0);
            this.p1.set(x1, y0, z0);
            this.p2.set(x1, y0, z1);
            this.p3.set(x0, y0, z1);
            v0i = this.V(this.p0, ao1m, 0.0f, 0.0f);
            v1i = this.V(this.p1, ao1mp, 1.0f, 0.0f);
            v2i = this.V(this.p2, ao11p, 1.0f, 1.0f);
            v3i = this.V(this.p3, ao11, 0.0f, 1.0f);
        } else if (nz == 1) {
            this.p0.set(x1, y1, z1);
            this.p1.set(x0, y1, z1);
            this.p2.set(x0, y0, z1);
            this.p3.set(x1, y0, z1);
            v0i = this.V(this.p0, ao11p, u1, v1);
            v1i = this.V(this.p1, ao11, u0, v1);
            v2i = this.V(this.p2, ao1m, u0, v0);
            v3i = this.V(this.p3, ao1mp, u1, v0);
        } else {
            this.p0.set(x0, y1, z0);
            this.p1.set(x1, y1, z0);
            this.p2.set(x1, y0, z0);
            this.p3.set(x0, y0, z0);
            v0i = this.V(this.p0, ao11, u0, v1);
            v1i = this.V(this.p1, ao11p, u1, v1);
            v2i = this.V(this.p2, ao1mp, u1, v0);
            v3i = this.V(this.p3, ao1m, u0, v0);
        }
        mb.rect(v0i, v1i, v2i, v3i);
    }

    private MeshPartBuilder.VertexInfo V(Vector3 pos, float ao, float u, float v) {
        this.tmpColor.a = 1.0f;
        this.tmpColor.b = 1.0f;
        this.tmpColor.g = 1.0f;
        this.tmpColor.r = 1.0f;
        this.tmpColor.mul(ao);
        return new MeshPartBuilder.VertexInfo().setPos(pos).setNor(this.n).setCol(this.tmpColor).setUV(u, v);
    }

    private float aoLutSample(World snap, int x, int y, int z, int nx, int ny, int nz, int su, int sv) {
        int ux = 0;
        int uy = 0;
        int uz = 0;
        int vx = 0;
        int vy = 0;
        int vz = 0;
        if (nx != 0) {
            uy = sv;
            vz = su;
        } else if (ny != 0) {
            ux = su;
            vz = sv;
        } else {
            ux = su;
            vy = sv;
        }
        int bx = x + nx;
        int by = y + ny;
        int bz = z + nz;
        boolean s1 = ChunkMesherColorAO.isSolid(snap, bx + ux, by + uy, bz + uz);
        boolean s2 = ChunkMesherColorAO.isSolid(snap, bx + vx, by + vy, bz + vz);
        boolean c = ChunkMesherColorAO.isSolid(snap, bx + ux + vx, by + uy + vy, bz + uz + vz);
        int lvl = s1 && s2 ? 3 : (s1 ? 1 : 0) + (s2 ? 1 : 0) + (c ? 1 : 0);
        return AO_LUT[lvl];
    }

    private static boolean isSolid(World snap, int x, int y, int z) {
        int cz;
        if (y < 0 || y >= 128) {
            return false;
        }
        int cx = ChunkPos.toChunkX(x);
        Chunk col = snap.getChunk(cx, cz = ChunkPos.toChunkZ(z));
        if (col == null) {
            return false;
        }
        short b = col.getBlock(x, y, z);
        return BlockRegistry.byId((short)Block.type((short)b)).solid;
    }

    private static boolean isOpaque(World snap, int x, int y, int z) {
        int cz;
        if (y < 0 || y >= 128) {
            return false;
        }
        int cx = ChunkPos.toChunkX(x);
        Chunk col = snap.getChunk(cx, cz = ChunkPos.toChunkZ(z));
        if (col == null) {
            return false;
        }
        short b = col.getBlock(x, y, z);
        return BlockRegistry.byId((short)Block.type((short)b)).opaque;
    }
}

