/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;

public final class DayNightCycle {
    public final Environment env = new Environment();
    private final DirectionalLight sun = new DirectionalLight();
    private final Color ambDay = new Color(0.35f, 0.35f, 0.35f, 1.0f);
    private final Color ambNight = new Color(0.05f, 0.05f, 0.08f, 1.0f);
    private final Color sunDayColor = new Color(0.95f, 0.95f, 0.9f, 1.0f);
    private final Color sunNightColor = new Color(0.2f, 0.22f, 0.35f, 1.0f);
    private final Vector3 sunDayDir = new Vector3(-0.6f, -1.0f, -0.3f).nor();
    private final Vector3 sunNightDir = new Vector3(-0.3f, -1.0f, -0.1f).nor();
    private final Color bgDay = new Color(0.52f, 0.74f, 1.0f, 1.0f);
    private final Color bgNight = new Color(0.02f, 0.02f, 0.05f, 1.0f);
    public final Color currentBg = new Color(this.bgDay);

    public DayNightCycle() {
        this.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, this.ambDay));
        this.env.add(this.sun);
        this.sun.set(this.sunDayColor, this.sunDayDir);
    }

    public void setTime(float t) {
        t = MathUtils.clamp(t, 0.0f, 1.0f);
        Color amb = new Color(MathUtils.lerp(this.ambDay.r, this.ambNight.r, t), MathUtils.lerp(this.ambDay.g, this.ambNight.g, t), MathUtils.lerp(this.ambDay.b, this.ambNight.b, t), 1.0f);
        this.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, amb));
        Color sc = new Color(MathUtils.lerp(this.sunDayColor.r, this.sunNightColor.r, t), MathUtils.lerp(this.sunDayColor.g, this.sunNightColor.g, t), MathUtils.lerp(this.sunDayColor.b, this.sunNightColor.b, t), 1.0f);
        Vector3 sd = new Vector3(MathUtils.lerp(this.sunDayDir.x, this.sunNightDir.x, t), MathUtils.lerp(this.sunDayDir.y, this.sunNightDir.y, t), MathUtils.lerp(this.sunDayDir.z, this.sunNightDir.z, t)).nor();
        this.sun.set(sc, sd);
        this.currentBg.set(MathUtils.lerp(this.bgDay.r, this.bgNight.r, t), MathUtils.lerp(this.bgDay.g, this.bgNight.g, t), MathUtils.lerp(this.bgDay.b, this.bgNight.b, t), 1.0f);
    }
}

