/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.game;

import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.utils.Disposable;
import de.hsw.mertcraft.game.ChunkMesherColorAO;
import de.hsw.mertcraft.io.BlockRenderPalette;
import de.hsw.mertcraft.io.BlockTexturePalette;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.SectionPos;
import de.hsw.mertcraft.shared.world.World;
import de.hsw.mertcraft.shared.world.WorldListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WorldRenderer
implements Disposable,
WorldListener {
    private final World world;
    private final ChunkMesherColorAO mesher;
    private final ConcurrentLinkedQueue<long[]> toBuild = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<long[]> toUnload = new ConcurrentLinkedQueue();
    private final Map<Long, ModelInstance> sections = new ConcurrentHashMap<Long, ModelInstance>();
    private int maxUploadsPerFrame = 2;
    private int minSy = 0;
    private int maxSy = 7;

    public WorldRenderer(World world, BlockRenderPalette palette, BlockTexturePalette texturePalette) {
        this.world = world;
        this.mesher = new ChunkMesherColorAO(palette, texturePalette);
    }

    public void updateVisible(float px, float pz) {
        Set<Long> colsShouldExist = this.world.ensureLoadedAround(px, pz, 5);
        HashSet<Long> shouldExist = new HashSet<Long>();
        for (long colKey : colsShouldExist) {
            int cz;
            int cx = (int)(colKey >> 32);
            Chunk col = this.world.getChunk(cx, cz = (int)colKey);
            if (col == null) continue;
            for (int sy = 0; sy < 8; ++sy) {
                Model model;
                if (col.getSection(sy) == null) continue;
                long sKey = WorldRenderer.sectionKey(cx, sy, cz);
                shouldExist.add(sKey);
                if (this.sections.containsKey(sKey) || (model = this.mesher.buildSectionModel(this.world, col, sy)) == null) continue;
                this.sections.put(sKey, new ModelInstance(model));
            }
        }
        Iterator<Map.Entry<Long, ModelInstance>> it = this.sections.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, ModelInstance> e = it.next();
            if (shouldExist.contains(e.getKey())) continue;
            ModelInstance inst = e.getValue();
            if (inst.model != null) {
                inst.model.dispose();
            }
            it.remove();
        }
    }

    public void notifyChange(int x, int y, int z) {
        int CSX = 16;
        int CSZ = 16;
        int SH = 16;
        int cx = Math.floorDiv(x, 16);
        int cz = Math.floorDiv(z, 16);
        int sy = SectionPos.toSectionY(y);
        int lx = Math.floorMod(x, 16);
        int lz = Math.floorMod(z, 16);
        int ly = Math.floorMod(y, 16);
        this.markDirtySection(cx, sy, cz);
        if (lx == 0) {
            this.markDirtySection(cx - 1, sy, cz);
        } else if (lx == 15) {
            this.markDirtySection(cx + 1, sy, cz);
        }
        if (lz == 0) {
            this.markDirtySection(cx, sy, cz - 1);
        } else if (lz == 15) {
            this.markDirtySection(cx, sy, cz + 1);
        }
        if (ly == 0) {
            this.markDirtySection(cx, sy - 1, cz);
        } else if (ly == 15) {
            this.markDirtySection(cx, sy + 1, cz);
        }
    }

    public void markDirtySection(int cx, int sy, int cz) {
        long key = WorldRenderer.sectionKey(cx, sy, cz);
        ModelInstance inst = this.sections.remove(key);
        if (inst != null && inst.model != null) {
            inst.model.dispose();
        }
    }

    public void render(ModelBatch batch, Environment environment) {
        for (ModelInstance inst : this.sections.values()) {
            batch.render((RenderableProvider)inst, environment);
        }
    }

    public void cleanup() {
        long[] s;
        while ((s = this.toUnload.poll()) != null) {
            long key = WorldRenderer.sectionKey((int)s[0], (int)s[1], (int)s[2]);
            ModelInstance inst = this.sections.remove(key);
            if (inst == null || inst.model == null) continue;
            inst.model.dispose();
        }
        int uploads = 0;
        while (uploads < this.maxUploadsPerFrame && (s = this.toBuild.poll()) != null) {
            int cx = (int)s[0];
            int sy = (int)s[1];
            int cz = (int)s[2];
            Model model = this.buildModelSection(cx, sy, cz);
            if (model == null) continue;
            long key = WorldRenderer.sectionKey(cx, sy, cz);
            ModelInstance old = this.sections.put(key, new ModelInstance(model));
            if (old != null && old.model != null) {
                old.model.dispose();
            }
            ++uploads;
        }
    }

    private Model buildModelSection(int cx, int sy, int cz) {
        return this.mesher.buildSectionModel(this.world, this.world.getOrCreateChunk(cx, cz), sy);
    }

    public void setMaxUploadsPerFrame(int v) {
        this.maxUploadsPerFrame = Math.max(1, v);
    }

    public void setSectionYRange(int min, int max) {
        this.minSy = min;
        this.maxSy = max;
    }

    @Override
    public void dispose() {
        for (ModelInstance inst : this.sections.values()) {
            if (inst.model == null) continue;
            inst.model.dispose();
        }
        this.sections.clear();
    }

    private static long sectionKey(int cx, int sy, int cz) {
        long colKey = (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
        return colKey << 8 ^ (long)sy & 0xFFL;
    }

    @Override
    public void onColumnLoaded(int cx, int cz) {
        for (int sy = this.minSy; sy <= this.maxSy; ++sy) {
            this.toBuild.add(new long[]{cx, sy, cz});
        }
    }

    @Override
    public void onColumnUnloaded(int cx, int cz) {
        for (int sy = this.minSy; sy <= this.maxSy; ++sy) {
            this.toUnload.add(new long[]{cx, sy, cz});
        }
    }

    @Override
    public void onBlockChanged(int wx, int wy, int wz) {
        int cx = Math.floorDiv(wx, 16);
        int sy = Math.floorDiv(wy, 16);
        int cz = Math.floorDiv(wz, 16);
        this.toBuild.add(new long[]{cx, sy, cz});
    }
}

