/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.game.world;

import de.hsw.mertcraft.game.GameSession;
import de.hsw.mertcraft.io.ChunkSectionLoader;
import de.hsw.mertcraft.shared.entity.Player;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.World;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;

public class ClientWorld
extends World {
    public static final int PLAYER_VIEW_CHUNKS = 5;
    private final HashMap<UUID, Player> players = new HashMap();
    private final ChunkSectionLoader sectionLoader = new ChunkSectionLoader(GameSession.getInstance());

    public ClientWorld(long seed) {
        super(seed);
    }

    public void addPlayer(Player player) {
        this.players.put(player.getId(), player);
    }

    public void removePlayer(Player player) {
        this.players.remove(player.getId());
    }

    public void removePlayer(UUID id) {
        this.players.remove(id);
    }

    public Player getPlayer(UUID id) {
        return this.players.get(id);
    }

    public Collection<Player> getPlayers() {
        return this.players.values();
    }

    public void update() {
        this.sectionLoader.update();
    }

    @Override
    public Chunk getOrCreateChunk(int cx, int cz) {
        Chunk old = this.getChunk(cx, cz);
        Chunk newChunk = super.getOrCreateChunk(cx, cz);
        if (old == null && newChunk != null) {
            for (int sy = 0; sy < 8; ++sy) {
                this.sectionLoader.load(cx, sy, cz);
            }
        }
        return newChunk;
    }

    @Generated
    public ChunkSectionLoader getSectionLoader() {
        return this.sectionLoader;
    }
}

