/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.io;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;

public final class BlockTexturePalette {
    private final ObjectMap<String, Def> defs = new ObjectMap();
    private final ObjectMap<String, Texture> cache = new ObjectMap();

    public BlockTexturePalette(FileHandle jsonFile) {
        JsonValue root = new JsonReader().parse(jsonFile);
        JsonValue blocks = root.get("blocks");
        JsonValue b = blocks.child;
        while (b != null) {
            Def d = new Def();
            d.all = BlockTexturePalette.getStr(b, "all");
            d.top = BlockTexturePalette.getStr(b, "top");
            d.bottom = BlockTexturePalette.getStr(b, "bottom");
            d.side = BlockTexturePalette.getStr(b, "side");
            d.px = BlockTexturePalette.getStr(b, "px");
            d.nx = BlockTexturePalette.getStr(b, "nx");
            d.py = BlockTexturePalette.getStr(b, "py");
            d.ny = BlockTexturePalette.getStr(b, "ny");
            d.pz = BlockTexturePalette.getStr(b, "pz");
            d.nz = BlockTexturePalette.getStr(b, "nz");
            this.defs.put(b.name, d);
            b = b.next;
        }
    }

    private static String getStr(JsonValue v, String k) {
        return v.has(k) ? v.getString(k) : null;
    }

    public Texture texture(String blockKey, Face face) {
        Def d = this.defs.get(blockKey);
        if (d == null) {
            return null;
        }
        String path = null;
        switch (face) {
            case PY: {
                path = BlockTexturePalette.first(d.py, d.top, d.all);
                break;
            }
            case NY: {
                path = BlockTexturePalette.first(d.ny, d.bottom, d.all);
                break;
            }
            case PX: {
                path = BlockTexturePalette.first(d.px, d.side, d.all);
                break;
            }
            case NX: {
                path = BlockTexturePalette.first(d.nx, d.side, d.all);
                break;
            }
            case PZ: {
                path = BlockTexturePalette.first(d.pz, d.side, d.all);
                break;
            }
            case NZ: {
                path = BlockTexturePalette.first(d.nz, d.side, d.all);
            }
        }
        if (path == null) {
            return null;
        }
        Texture tex = this.cache.get(path);
        if (tex == null) {
            tex = new Texture(Gdx.files.internal(path));
            tex.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
            tex.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
            this.cache.put(path, tex);
        }
        return tex;
    }

    private static String first(String ... ss) {
        for (String s : ss) {
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public void dispose() {
        for (Texture e : this.cache.values()) {
            e.dispose();
        }
        this.cache.clear();
    }

    private static final class Def {
        String all;
        String top;
        String bottom;
        String side;
        String px;
        String nx;
        String py;
        String ny;
        String pz;
        String nz;

        private Def() {
        }
    }

    public static enum Face {
        PX,
        NX,
        PY,
        NY,
        PZ,
        NZ;

    }
}

