/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import de.hsw.mertcraft.MertCraft;
import de.hsw.mertcraft.controll.GameCamera;
import de.hsw.mertcraft.controll.WorldEditorController;
import de.hsw.mertcraft.entity.VoxelPlayer;
import de.hsw.mertcraft.game.DayNightCycle;
import de.hsw.mertcraft.game.GameSession;
import de.hsw.mertcraft.game.PlayerController;
import de.hsw.mertcraft.game.WorldRenderer;
import de.hsw.mertcraft.game.world.ClientWorld;
import de.hsw.mertcraft.io.BlockRenderPalette;
import de.hsw.mertcraft.io.BlockTexturePalette;
import de.hsw.mertcraft.screen.Hud;
import de.hsw.mertcraft.shared.entity.Player;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class GameScreen
extends ScreenAdapter {
    private GameCamera cam;
    private ModelBatch batch;
    private Environment env;
    private final ClientWorld world = GameSession.getInstance().getWorld();
    private WorldRenderer worldRenderer;
    private Player self;
    private PlayerController playerController;
    private WorldEditorController editor;
    private Hud hud;
    private final DayNightCycle cycle = new DayNightCycle();
    PointLight playerLight = new PointLight().set(1.0f, 0.9f, 0.7f, 0.0f, 0.0f, 0.0f, 8.0f);
    private final BlockRenderPalette colorPalette;
    private final BlockTexturePalette texturePalette;
    public final HashMap<Player, VoxelPlayer> renderPlayers = new HashMap();
    private float time = 0.0f;
    private float lightAcc = 0.01f;
    private boolean up = true;
    private boolean flashLight = false;
    private final Vector3 flashLightPos = new Vector3();
    private final Vector3 oldPosition = new Vector3();
    private final Vector3 tmp = new Vector3();
    private final Vector3 tmp2 = new Vector3();
    private final Vector3 vecw = new Vector3();
    private final BitmapFont font;
    private final GlyphLayout layout;

    public GameScreen() {
        this.font = MertCraft.instance.skin.getFont("font");
        this.layout = new GlyphLayout();
        DefaultShader.Config cfg = new DefaultShader.Config();
        cfg.numPointLights = 2;
        this.batch = new ModelBatch(new DefaultShaderProvider(cfg));
        this.env = new Environment();
        this.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 0.7f, 0.7f, 0.75f, 1.0f));
        this.env.add(new DirectionalLight().set(1.0f, 1.0f, 1.0f, -1.0f, -0.8f, -0.2f));
        this.cycle.env.add(this.playerLight);
        this.cam = new GameCamera(75.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), this.world);
        this.cam.near = 0.2f;
        this.cam.far = 512.0f;
        this.cam.update(true);
        this.colorPalette = BlockRenderPalette.load("block_colors.json");
        this.texturePalette = new BlockTexturePalette(Gdx.files.internal("block_textures.json"));
        this.worldRenderer = new WorldRenderer(this.world, this.colorPalette, this.texturePalette);
        this.playerController = new PlayerController(this.world);
        this.editor = new WorldEditorController(this.world, this.cam);
        this.self = GameSession.getInstance().getSelf();
    }

    @Override
    public void show() {
        this.hud = new Hud(this.cam, this.world, this.texturePalette);
    }

    @Override
    public void render(float delta) {
        GameSession.getInstance().updateListener();
        float dt = Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f);
        this.oldPosition.set(this.self.getX(), this.self.getY(), this.self.getZ());
        this.playerController.update(dt, this.cam);
        if (Gdx.input.isKeyJustPressed(59)) {
            boolean bl = this.flashLight = !this.flashLight;
        }
        if (this.flashLight) {
            this.flashLightPos.set(this.self.getX(), this.self.getY(), this.self.getZ());
            Vector3 p = this.flashLightPos;
            this.playerLight.setPosition(p);
            this.playerLight.intensity = 1.0f;
            this.playerLight.set(this.playerLight.color, p, 8.0f);
        }
        this.editor.update();
        this.worldRenderer.updateVisible(this.cam.position.x, this.cam.position.z);
        if (this.up) {
            this.time += delta * this.lightAcc;
            this.cycle.setTime(this.time);
            if (this.time >= 1.0f) {
                this.up = false;
            }
        } else {
            this.time -= delta * this.lightAcc;
            this.cycle.setTime(this.time);
            if (this.time <= 0.0f) {
                this.up = true;
            }
        }
        Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.gl.glClearColor(this.cycle.currentBg.r, this.cycle.currentBg.g, this.cycle.currentBg.b, this.cycle.currentBg.a);
        Gdx.gl.glClear(16640);
        this.batch.begin(this.cam);
        this.worldRenderer.render(this.batch, this.cycle.env);
        for (Map.Entry entry : this.renderPlayers.entrySet()) {
            Player player = (Player)entry.getKey();
            this.tmp.set(player.getX(), player.getY() - 1.0f, player.getZ());
            this.tmp2.set(player.velX, player.velY, player.velZ);
            ((VoxelPlayer)entry.getValue()).update(this.tmp, this.tmp2, player.yaw, player.pitch, dt);
            ((VoxelPlayer)entry.getValue()).render(this.batch, this.cycle.env);
        }
        this.batch.end();
        Gdx.gl.glDisable(2929);
        Gdx.gl.glDepthMask(false);
        Batch nameBatch = MertCraft.instance.stage.getBatch();
        MertCraft.instance.stage.getCamera().update();
        nameBatch.setProjectionMatrix(MertCraft.instance.stage.getCamera().combined);
        nameBatch.begin();
        for (Map.Entry<Player, VoxelPlayer> entry : this.renderPlayers.entrySet()) {
            if (entry.getKey().equals(this.self)) continue;
            this.renderPlayerName(nameBatch, entry.getKey());
        }
        nameBatch.end();
        Gdx.gl.glDepthMask(true);
        Gdx.gl.glEnable(2929);
        this.worldRenderer.cleanup();
        this.hud.render();
    }

    private void renderPlayerName(Batch batch, Player player) {
        this.vecw.set(player.getX(), player.getY() + 1.8f, player.getZ());
        Vector3 screen = this.cam.project(this.vecw.cpy());
        if (screen.z <= 0.0f || screen.z >= 1.0f) {
            return;
        }
        float dist = this.cam.position.dst(this.vecw);
        float scale = MathUtils.clamp(8.0f / dist, 0.6f, 1.3f);
        float oldScale = this.font.getData().scaleX;
        this.font.getData().setScale(scale);
        String name = player.getName();
        this.layout.setText(this.font, name);
        float x = screen.x - this.layout.width * 0.5f;
        float y = screen.y + 18.0f;
        this.font.setColor(0.0f, 0.0f, 0.0f, 0.7f);
        this.font.draw(batch, name, x + 1.0f, y - 1.0f);
        this.font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.font.draw(batch, name, x, y);
        this.font.getData().setScale(oldScale);
    }

    @Override
    public void resize(int w, int h) {
        this.cam.viewportWidth = w;
        this.cam.viewportHeight = h;
        this.cam.update();
        this.hud.update(w, h);
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.worldRenderer.dispose();
        this.hud.dispose();
    }

    @Generated
    public WorldRenderer getWorldRenderer() {
        return this.worldRenderer;
    }
}

