/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Disposable;
import de.hsw.mertcraft.MertCraft;
import de.hsw.mertcraft.controll.GameCamera;
import de.hsw.mertcraft.io.BlockTexturePalette;
import de.hsw.mertcraft.shared.block.BlockRegistry;
import de.hsw.mertcraft.shared.block.BlockType;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.World;

public class Hud
implements Disposable {
    private final PerspectiveCamera handCam;
    private final Stack[] slots;
    private final Stack selectedSlot;
    private final World world;
    private final ShapeRenderer shapeRenderer;
    private final Skin skin;
    private final Stage stage;
    private final Label fps;
    private final Label position;
    private final Label chunk;
    private final GameCamera camera;

    public Hud(GameCamera camera, World world, BlockTexturePalette palette) {
        this.skin = MertCraft.instance.skin;
        this.stage = MertCraft.instance.stage;
        this.fps = new Label((CharSequence)"", this.skin);
        this.position = new Label((CharSequence)"", this.skin);
        this.chunk = new Label((CharSequence)"", this.skin);
        this.camera = camera;
        this.world = world;
        this.shapeRenderer = new ShapeRenderer();
        this.handCam = new PerspectiveCamera(75.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.handCam.near = 0.02f;
        this.handCam.far = 10.0f;
        Table debug = new Table();
        debug.setFillParent(true);
        this.stage.addActor(debug);
        Table wrap = new Table();
        wrap.add(this.fps).expandX().left().row();
        wrap.add(this.position).expandX().left().row();
        wrap.add(this.chunk).expandX().left().row();
        debug.add(wrap).expand().left().top().row();
        Table bottom = new Table();
        Table hearts = new Table();
        for (int i = 0; i < 10; ++i) {
            hearts.add(new Image(this.skin, "heart"));
        }
        bottom.add(hearts).expandX().left().row();
        Table container = new Table();
        this.slots = new Stack[9];
        for (int i = 0; i < 9; ++i) {
            Texture texture;
            Table table = new Table(this.skin);
            table.setBackground("cell");
            BlockType type = BlockRegistry.byId((short)(i + 1));
            if (type != null && (texture = palette.texture(type.name, BlockTexturePalette.Face.PX)) != null) {
                table.add(new Image(texture)).expand().size(48.0f);
            }
            container.add(table).size(64.0f);
        }
        bottom.add(container);
        debug.add(bottom).expand().padBottom(20.0f).bottom();
        this.selectedSlot = this.slots[0];
    }

    public void render() {
        this.fps.setText("FPS: " + Gdx.graphics.getFramesPerSecond());
        this.position.setText("X: " + String.format("%.2f", Float.valueOf(this.camera.position.x)) + ", Y: " + String.format("%.2f", Float.valueOf(this.camera.position.y)) + ", Z: " + String.format("%.2f", Float.valueOf(this.camera.position.z)));
        int chunkX = Math.floorDiv((int)this.camera.position.x, 16);
        int chunkZ = Math.floorDiv((int)this.camera.position.z, 16);
        Chunk col = this.world.getChunk(chunkX, chunkZ);
        if (col != null) {
            this.chunk.setText("ChunkX: " + chunkX + ", ChunkZ: " + chunkZ);
        }
        this.stage.draw();
        Gdx.gl.glDisable(2929);
        this.shapeRenderer.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.identity();
        float cx = (float)Gdx.graphics.getWidth() / 2.0f;
        float cy = (float)Gdx.graphics.getHeight() / 2.0f;
        this.shapeRenderer.line(cx - 8.0f, cy, cx + 8.0f, cy);
        this.shapeRenderer.line(cx, cy - 8.0f, cx, cy + 8.0f);
        this.shapeRenderer.end();
        Gdx.gl.glEnable(2929);
        GameCamera.Hit hit = this.camera.raycastBlock(5.0f);
        if (hit == null) {
            return;
        }
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        float x = hit.bx;
        float y = hit.by;
        float z = hit.bz;
        float size = 1.0f;
        float x2 = x + size;
        float y2 = y + size;
        float z2 = z + size;
        this.shapeRenderer.line(x, y, z, x2, y, z);
        this.shapeRenderer.line(x2, y, z, x2, y, z2);
        this.shapeRenderer.line(x2, y, z2, x, y, z2);
        this.shapeRenderer.line(x, y, z2, x, y, z);
        this.shapeRenderer.line(x, y2, z, x2, y2, z);
        this.shapeRenderer.line(x2, y2, z, x2, y2, z2);
        this.shapeRenderer.line(x2, y2, z2, x, y2, z2);
        this.shapeRenderer.line(x, y2, z2, x, y2, z);
        this.shapeRenderer.line(x, y, z, x, y2, z);
        this.shapeRenderer.line(x2, y, z, x2, y2, z);
        this.shapeRenderer.line(x2, y, z2, x2, y2, z2);
        this.shapeRenderer.line(x, y, z2, x, y2, z2);
        this.shapeRenderer.end();
    }

    public void update(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.shapeRenderer.dispose();
        this.skin.dispose();
    }
}

