/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.block;

import de.hsw.mertcraft.shared.block.Block;
import de.hsw.mertcraft.shared.block.BlockType;
import java.util.HashMap;
import java.util.Map;

public final class BlockRegistry {
    private static final Map<Short, BlockType> byId = new HashMap<Short, BlockType>();
    private static final Map<String, BlockType> byName = new HashMap<String, BlockType>();
    private static short nextId = 1;
    public static final BlockType AIR = BlockRegistry.register(0, "air", false, false, false, (byte)0, (byte)0);
    public static final BlockType STONE = BlockRegistry.register("stone", true, true, true, (byte)0, (byte)15);
    public static final BlockType DIRT = BlockRegistry.register("dirt", true, true, true, (byte)0, (byte)15);
    public static final BlockType GRASS = BlockRegistry.register("grass", true, true, true, (byte)0, (byte)15);
    public static final BlockType OAK_LOG = BlockRegistry.register("oak_log", true, true, true, (byte)0, (byte)15);
    public static final BlockType OAK_LEAVES = BlockRegistry.register("oak_leaves", true, true, true, (byte)0, (byte)15);

    private static BlockType register(String name, boolean solid, boolean opaque, boolean selectable, byte emit, byte opacity) {
        short s = nextId;
        nextId = (short)(s + 1);
        short id = s;
        return BlockRegistry.register(id, name, solid, opaque, selectable, emit, opacity);
    }

    private static BlockType register(int idInt, String name, boolean solid, boolean opaque, boolean selectable, byte emit, byte opacity) {
        short id = (short)idInt;
        BlockType t = new BlockType(id, name, solid, opaque, selectable, emit, opacity);
        byId.put(id, t);
        byName.put(name, t);
        return t;
    }

    public static BlockType unpack(short packed) {
        return BlockRegistry.byId(Block.type(packed));
    }

    public static BlockType byId(short id) {
        return byId.getOrDefault(id, AIR);
    }

    public static BlockType byName(String name) {
        return byName.getOrDefault(name, AIR);
    }

    public static short maxId() {
        return (short)(nextId - 1);
    }

    private BlockRegistry() {
    }
}

