/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.net.packet;

import de.hsw.mertcraft.shared.log.Log;
import de.hsw.mertcraft.shared.net.NetConnection;
import de.hsw.mertcraft.shared.serialize.BinarySerializer;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class PacketRegister {
    private final HashMap<Class, PacketReader> reg = new HashMap();

    public void onReceive(NetConnection connection, ByteBuffer data) {
        Object packet = BinarySerializer.deserialize(data);
        PacketReader reader = this.reg.get(packet.getClass());
        if (reader == null) {
            Log.error("PacketRegister", "Tried to read " + packet.getClass() + " but its not registered!");
            return;
        }
        reader.read(connection, packet);
    }

    public <T> PacketRegister register(Class<T> clazz, PacketReader<T> reader) {
        this.reg.put(clazz, reader);
        return this;
    }

    public static interface PacketReader<T> {
        public void read(NetConnection var1, T var2);
    }
}

