/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.net.rpc;

import lombok.Generated;

public class DelayedResponse<T> {
    private long timeout;
    private T value;
    private boolean obtained;
    private Subscription<T> listener;

    public DelayedResponse() {
    }

    public DelayedResponse(T value) {
        this.value = value;
        this.obtained = true;
    }

    public DelayedResponse(long timeout) {
        this.timeout = timeout;
    }

    public DelayedResponse(Subscription<T> subscriber) {
        this.listener = subscriber;
    }

    void obtain(T value) {
        if (this.isDone()) {
            return;
        }
        if (!this.isTimeout()) {
            this.value = value;
            this.obtained = true;
        }
        if (this.listener != null) {
            this.listener.obtained(value, this.obtained);
        }
    }

    public void subscribe(Subscription<T> func) {
        this.listener = func;
    }

    public boolean hasValue() {
        return this.obtained;
    }

    public boolean isDone() {
        return this.hasValue() || this.isTimeout();
    }

    public boolean isTimeout() {
        return this.timeout > 0L && System.currentTimeMillis() >= this.timeout;
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    public static interface Subscription<T> {
        public void obtained(T var1, boolean var2);
    }
}

