/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.net.rpc;

import de.hsw.mertcraft.shared.log.Log;
import de.hsw.mertcraft.shared.net.NetConnection;
import de.hsw.mertcraft.shared.net.rpc.DelayedResponse;
import de.hsw.mertcraft.shared.net.rpc.RPCException;
import de.hsw.mertcraft.shared.net.rpc.RPCHandler;
import java.util.HashMap;
import lombok.Generated;

public abstract class RPCService<I, O> {
    long transactionId = 0L;
    final HashMap<Long, DelayedResponse<O>> queue = new HashMap();
    private RPCHandler handler;
    private Executor<I, O> executor;
    private DelayedResponse.Subscription<O> autoSubscription;

    void init(RPCHandler handler) {
        this.handler = handler;
    }

    void setExecutor(Executor<I, O> executor) {
        this.executor = executor;
        executor.service = this;
    }

    public DelayedResponse<O> execute(NetConnection target, I param) {
        return this.executor.invoke(target, param);
    }

    private DelayedResponse<O> executeRemote(NetConnection target, I param, long timeout) {
        if (this.handler == null) {
            throw new RPCException("The service hasn't been registered yet!");
        }
        this.handler.handleRemote(target, this, (byte)0, this.transactionId, param);
        DelayedResponse<O> response = new DelayedResponse<O>(timeout);
        this.queue.put(this.transactionId, response);
        this.transactionId = (int)(this.transactionId + 1L & 0xFFFFFFFFL);
        if (this.autoSubscription != null) {
            response.subscribe(this.autoSubscription);
        }
        return response;
    }

    void receive(long id, O t) {
        DelayedResponse<O> response = this.queue.remove(id);
        if (response == null) {
            Log.warn(this.getClass().getSimpleName(), "Tried to give a value to a response (id: " + id + ") but there is response queued for the id");
            return;
        }
        response.obtain(t);
    }

    @Generated
    public void setAutoSubscription(DelayedResponse.Subscription<O> autoSubscription) {
        this.autoSubscription = autoSubscription;
    }

    public static abstract class Executor<I, O> {
        protected RPCService<I, O> service;

        public abstract DelayedResponse<O> invoke(NetConnection var1, I var2);

        protected DelayedResponse<O> executeRemote(NetConnection target, I param, long timeout) {
            return ((RPCService)this.service).executeRemote(target, param, timeout);
        }

        protected DelayedResponse<O> executeRemote(NetConnection target, I param) {
            return ((RPCService)this.service).executeRemote(target, param, 0L);
        }
    }

    public static class RemoteExecutor<I, O>
    extends Executor<I, O> {
        private long timeout;

        @Override
        public DelayedResponse<O> invoke(NetConnection target, I param) {
            return this.executeRemote(target, param, this.timeout);
        }

        @Generated
        public RemoteExecutor(long timeout) {
            this.timeout = timeout;
        }

        @Generated
        public RemoteExecutor() {
        }
    }
}

