/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.serialize;

import de.hsw.mertcraft.shared.net.packet.ChangeBlockPacket;
import de.hsw.mertcraft.shared.net.packet.client.ClientInteractPacket;
import de.hsw.mertcraft.shared.net.packet.client.ClientJoinPacket;
import de.hsw.mertcraft.shared.net.packet.client.ClientMovePacket;
import de.hsw.mertcraft.shared.net.packet.client.ClientRequestChunkSectionPacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerLoginPlayerPacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerPlayerJoinedPacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerPlayerQuitPacked;
import de.hsw.mertcraft.shared.net.packet.server.ServerSendChunkSectionPacket;
import de.hsw.mertcraft.shared.net.packet.server.ServerWorldLoadStatePacket;
import de.hsw.mertcraft.shared.serialize.ISerializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public final class BinarySerializer {
    static final Map<Byte, ISerializer> MAP_BY_MASK = new HashMap<Byte, ISerializer>();
    static final Map<Class<?>, Byte> MAP_MASK_BY_CLASS = new HashMap();
    static final Map<Class<?>, ISerializer> MAP_BY_CLASS = new HashMap();
    private static byte nextMask = 0;

    private static <T> void register(Class<T> clazz, ISerializer<T> serializer) {
        MAP_BY_CLASS.put(clazz, serializer);
        MAP_BY_MASK.put(nextMask, serializer);
        MAP_MASK_BY_CLASS.put(clazz, nextMask);
        nextMask = (byte)(nextMask + 1);
    }

    public static ByteBuffer serialize(Object any) {
        ISerializer serializer = MAP_BY_CLASS.get(any.getClass());
        if (serializer == null) {
            throw new RuntimeException("Tried to serialize object of type " + any.getClass().getSimpleName() + " but the class is not registered!");
        }
        ByteBuffer buffer = ByteBuffer.allocate(serializer.getNecessarySize(any) + 1);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(MAP_MASK_BY_CLASS.get(any.getClass()));
        serializer.serialize(buffer, any);
        return buffer;
    }

    public static void serialize(Object any, ByteBuffer buffer) {
        BinarySerializer.serialize(any.getClass(), any, buffer);
    }

    public static void serialize(Class<?> clazz, Object any, ByteBuffer buffer) {
        ISerializer serializer = MAP_BY_CLASS.get(clazz);
        buffer.put(MAP_MASK_BY_CLASS.get(clazz));
        serializer.serialize(buffer, any);
    }

    public static Object deserialize(ByteBuffer buffer) {
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (buffer.position() > 0) {
            buffer.flip();
        }
        return BinarySerializer.deserializeFlipped(buffer);
    }

    public static Object deserializeFlipped(ByteBuffer buffer) {
        byte mask = buffer.get();
        return MAP_BY_MASK.get(mask).deserialize(buffer);
    }

    public static int getNeededSize(Class<?> clazz, Object any, boolean withMask) {
        return MAP_BY_CLASS.get(clazz).getNecessarySize(any) + (withMask ? 1 : 0);
    }

    public static int getNeededSize(Object any, boolean withMask) {
        return BinarySerializer.getNeededSize(any.getClass(), any, withMask);
    }

    static byte getMask(Class<?> clazz) {
        return MAP_MASK_BY_CLASS.get(clazz);
    }

    @Generated
    private BinarySerializer() {
    }

    static {
        BinarySerializer.register(ClientJoinPacket.class, new ClientJoinPacket.Serializer());
        BinarySerializer.register(ClientRequestChunkSectionPacket.class, new ClientRequestChunkSectionPacket.Serializer());
        BinarySerializer.register(ClientMovePacket.class, new ClientMovePacket.Serializer());
        BinarySerializer.register(ClientInteractPacket.class, new ClientInteractPacket.Serialize());
        BinarySerializer.register(ChangeBlockPacket.class, new ChangeBlockPacket.Serializer());
        BinarySerializer.register(ServerLoginPlayerPacket.class, new ServerLoginPlayerPacket.Serializer());
        BinarySerializer.register(ServerSendChunkSectionPacket.class, new ServerSendChunkSectionPacket.Serializer());
        BinarySerializer.register(ServerWorldLoadStatePacket.class, new ServerWorldLoadStatePacket.Serializer());
        BinarySerializer.register(ServerPlayerJoinedPacket.class, new ServerPlayerJoinedPacket.Serializer());
        BinarySerializer.register(ServerPlayerQuitPacked.class, new ServerPlayerQuitPacked.Serializer());
    }
}

