/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.util;

import java.lang.reflect.Array;

public class Array3d<E> {
    private final E[] array;
    private final int sx;
    private final int sy;
    private final int sz;

    public Array3d(Class<E> clazz, int width, int height, int length) {
        this.sx = width;
        this.sy = height;
        this.sz = length;
        this.array = (Object[])Array.newInstance(clazz, width * height * length);
    }

    private int idx(int x, int y, int z) {
        return x + this.sx * (y + this.sy * z);
    }

    public E get(int x, int y, int z) {
        return this.array[this.idx(x, y, z)];
    }

    public void set(int x, int y, int z, E e) {
        this.array[this.idx((int)x, (int)y, (int)z)] = e;
    }

    public boolean inBounds(int x, int y, int z) {
        return x >= 0 && x < this.sx && y >= 0 && y < this.sy && z >= 0 && z < this.sz;
    }
}

