/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.world;

import de.hsw.mertcraft.shared.block.Block;
import java.util.Arrays;
import lombok.Generated;

public final class ChunkSection {
    public static final int SIZE = 16;
    public static final int STRIDE_X = 1;
    public static final int STRIDE_Z = 16;
    public static final int STRIDE_Y = 256;
    private short[] blocks = new short[4096];
    private int nonAirCount = 0;

    public ChunkSection() {
        Arrays.fill(this.blocks, Block.pack(Block.AIR_ID, (byte)0));
    }

    public void setData(short[] blocks) {
        this.blocks = blocks;
        this.nonAirCount = 0;
        for (short block : blocks) {
            if (Block.isAir(block)) continue;
            ++this.nonAirCount;
        }
    }

    public short get(int lx, int ly, int lz) {
        return this.blocks[ChunkSection.index(lx, ly, lz)];
    }

    public void set(int lx, int ly, int lz, short packed) {
        int i = ChunkSection.index(lx, ly, lz);
        short prev = this.blocks[i];
        if (prev == packed) {
            return;
        }
        if (!Block.isAir(prev)) {
            --this.nonAirCount;
        }
        if (!Block.isAir(packed)) {
            ++this.nonAirCount;
        }
        this.blocks[i] = packed;
    }

    public boolean isEmptyAir() {
        return this.nonAirCount == 0;
    }

    private static int index(int lx, int ly, int lz) {
        return ly * 256 + lz * 16 + lx * 1;
    }

    @Generated
    public short[] getBlocks() {
        return this.blocks;
    }
}

