/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.world;

import de.hsw.mertcraft.shared.block.Block;
import de.hsw.mertcraft.shared.block.BlockRegistry;
import de.hsw.mertcraft.shared.block.BlockType;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.ChunkPos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class World {
    private final long seed;
    private final Map<Long, Chunk> chunks = new HashMap<Long, Chunk>();

    public World(long seed) {
        this.seed = seed;
    }

    public Set<Long> ensureLoadedAround(float px, float pz, int radiusCols) {
        int cxCenter = Math.floorDiv((int)Math.floor(px), 16);
        int czCenter = Math.floorDiv((int)Math.floor(pz), 16);
        HashSet<Long> touched = new HashSet<Long>();
        for (int dz = -radiusCols; dz <= radiusCols; ++dz) {
            for (int dx = -radiusCols; dx <= radiusCols; ++dx) {
                int cx = cxCenter + dx;
                int cz = czCenter + dz;
                long key = (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
                touched.add(key);
                if (this.getChunk(cx, cz) != null) continue;
                this.getOrCreateChunk(cx, cz);
            }
        }
        return touched;
    }

    protected long chunkKey(int cx, int cz) {
        return (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
    }

    public Chunk getOrCreateChunk(int cx, int cz) {
        long key = this.chunkKey(cx, cz);
        Chunk chunk = this.chunks.get(key);
        if (chunk == null) {
            chunk = new Chunk(cx, cz);
            this.chunks.put(key, chunk);
        }
        return chunk;
    }

    public Chunk getChunk(int cx, int cz) {
        long key = this.chunkKey(cx, cz);
        return this.chunks.get(key);
    }

    public short getBlock(int x, int y, int z) {
        int cz;
        int cx = ChunkPos.toChunkX(x);
        Chunk chunk = this.getChunk(cx, cz = ChunkPos.toChunkZ(z));
        return chunk == null ? Block.AIR_PACKED : chunk.getBlock(x, y, z);
    }

    public void setBlock(int x, int y, int z, short packed) {
        int cx = ChunkPos.toChunkX(x);
        int cz = ChunkPos.toChunkZ(z);
        this.getOrCreateChunk(cx, cz).setBlock(x, y, z, packed);
    }

    public boolean isSolid(int x, int y, int z) {
        short packed = this.getBlock(x, y, z);
        BlockType type = BlockRegistry.byId(Block.type(packed));
        return type != null && type.solid;
    }

    @Generated
    public long getSeed() {
        return this.seed;
    }
}

