/*
 * Decompiled with CFR 0.152.
 */
package de.hsw.mertcraft.shared.world;

import de.hsw.mertcraft.shared.block.Block;
import de.hsw.mertcraft.shared.block.BlockRegistry;
import de.hsw.mertcraft.shared.log.Log;
import de.hsw.mertcraft.shared.world.Chunk;
import de.hsw.mertcraft.shared.world.World;
import java.util.Random;

public final class WorldGenerator {
    private final long seed;
    private final int baseHeight = 48;
    private final int hillAmp = 18;
    private final int ridgeAmp = 10;
    private final float freqHills = 0.015625f;
    private final float freqRidge = 0.03125f;
    private final int dirtDepth = 3;
    private final Random random;

    public WorldGenerator(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public void generateColumn(World world, Chunk chunk) {
        Log.debug("WorldGenerator", "Building " + chunk.cz + ";" + chunk.cx);
        int wx0 = chunk.cx * 16;
        int wz0 = chunk.cz * 16;
        for (int lz = 0; lz < 16; ++lz) {
            int wz = wz0 + lz;
            for (int lx = 0; lx < 16; ++lx) {
                int y;
                int wx = wx0 + lx;
                float nHills = this.fbm2((float)wx * 0.015625f, (float)wz * 0.015625f, 5, 2.0f, 0.5f);
                float nRidge = 1.0f - Math.abs(this.fbm2((float)wx * 0.03125f, (float)wz * 0.03125f, 3, 2.0f, 0.5f));
                int h = 48 + Math.round(nHills * 18.0f) + Math.round(nRidge * 10.0f);
                if (h < 1) {
                    h = 1;
                }
                if (h > 126) {
                    h = 126;
                }
                for (y = 0; y < h - 3; ++y) {
                    chunk.setBlock(wx, y, wz, Block.pack(BlockRegistry.STONE.id, (byte)0));
                }
                for (y = Math.max(0, h - 3); y < h; ++y) {
                    chunk.setBlock(wx, y, wz, Block.pack(BlockRegistry.DIRT.id, (byte)0));
                }
                chunk.setBlock(wx, h, wz, Block.pack(BlockRegistry.GRASS.id, (byte)0));
                if (!(this.random.nextFloat() <= 0.01f)) continue;
                short log = Block.pack(BlockRegistry.OAK_LOG.id, (byte)0);
                chunk.setBlock(wx, h, wz, log);
                chunk.setBlock(wx, h + 1, wz, log);
                chunk.setBlock(wx, h + 2, wz, log);
                chunk.setBlock(wx, h + 3, wz, log);
                chunk.setBlock(wx, h + 4, wz, log);
                short leaves = Block.pack(BlockRegistry.OAK_LEAVES.id, (byte)0);
                int ly = h + 4;
                for (int dx = wx - 1; dx <= wx + 1; ++dx) {
                    for (int dz = wz - 1; dz <= wz + 1; ++dz) {
                        chunk.setBlock(dx, ly + 1, dz, leaves);
                        chunk.setBlock(dx, ly + 2, dz, leaves);
                    }
                }
                chunk.setBlock(wx, ly + 3, wz, leaves);
                chunk.setBlock(wx + 2, ly + 1, wz, leaves);
                chunk.setBlock(wx - 2, ly + 1, wz, leaves);
                chunk.setBlock(wx, ly + 1, wz + 2, leaves);
                chunk.setBlock(wx, ly + 1, wz - 2, leaves);
            }
        }
    }

    private float fbm2(float x, float y, int octaves, float lacunarity, float gain) {
        float sum = 0.0f;
        float amp = 1.0f;
        float freq = 1.0f;
        for (int i = 0; i < octaves; ++i) {
            sum += amp * this.valueNoise2D(x * freq, y * freq);
            freq *= lacunarity;
            amp *= gain;
        }
        return sum;
    }

    private float valueNoise2D(float x, float y) {
        int x0 = this.fastFloor(x);
        int y0 = this.fastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        float tx = x - (float)x0;
        float ty = y - (float)y0;
        float v00 = this.hash2f(x0, y0);
        float v10 = this.hash2f(x1, y0);
        float v01 = this.hash2f(x0, y1);
        float v11 = this.hash2f(x1, y1);
        float sx = this.fade(tx);
        float sy = this.fade(ty);
        float ix0 = this.lerp(v00, v10, sx);
        float ix1 = this.lerp(v01, v11, sx);
        return this.lerp(ix0, ix1, sy);
    }

    private int fastFloor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }

    private float fade(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    private float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    private float hash2f(int x, int y) {
        long h = this.seed ^ (long)x * 7146057691288625177L ^ (long)y * -7046029254386353131L;
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return (float)(h & 0xFFFFFFFFL) / 2.1474836E9f - 1.0f;
    }
}

