/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTDeviceEnumeration {
    protected EXTDeviceEnumeration() {
        throw new UnsupportedOperationException();
    }

    public static int neglQueryDevicesEXT(int max_devices, long devices, long num_devices) {
        long __functionAddress = EGL.getCapabilities().eglQueryDevicesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(max_devices, devices, num_devices, __functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDevicesEXT(@Nullable @NativeType(value="EGLDeviceEXT *") PointerBuffer devices, @NativeType(value="EGLint *") IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)num_devices, 1);
        }
        return EXTDeviceEnumeration.neglQueryDevicesEXT(Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddress(num_devices)) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglQueryDevicesEXT(@Nullable @NativeType(value="EGLDeviceEXT *") PointerBuffer devices, @NativeType(value="EGLint *") int[] num_devices) {
        long __functionAddress = EGL.getCapabilities().eglQueryDevicesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(num_devices, 1);
        }
        return JNI.callPPI(Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), num_devices, __functionAddress) != 0;
    }
}

